/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.spark.lib.protobuf.AbstractMessageLite;

public class BytebinClient {
    private final String url;
    private final String userAgent;

    public BytebinClient(String url, String userAgent) {
        this.url = url + (url.endsWith("/") ? "" : "/");
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content postContent(String contentType, Consumer<OutputStream> consumer) throws IOException {
        URL url = new URL(this.url + "post");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("User-Agent", this.userAgent);
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.connect();
            try (OutputStream output = connection.getOutputStream();){
                consumer.accept(output);
            }
            String key = connection.getHeaderField("Location");
            if (key == null) {
                throw new IllegalStateException("Key not returned");
            }
            Content content = new Content(key);
            return content;
        }
        finally {
            connection.getInputStream().close();
            connection.disconnect();
        }
    }

    public Content postContent(AbstractMessageLite<?, ?> proto, String contentType) throws IOException {
        return this.postContent(contentType, (OutputStream outputStream) -> {
            try (GZIPOutputStream out = new GZIPOutputStream((OutputStream)outputStream);){
                proto.writeTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static final class Content {
        private final String key;

        Content(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

